import request from '@/utils/request'

// 查询个税公司负担列表
export function listImportPersonalTaxCompanyBurden(query) {
  return request({
    url: '/salary/importPersonalTaxCompanyBurden/list',
    method: 'get',
    params: query
  })
}

// 查询个税公司负担详细
export function getImportPersonalTaxCompanyBurden(id) {
  return request({
    url: '/salary/importPersonalTaxCompanyBurden/' + id,
    method: 'get'
  })
}

// 新增个税公司负担
export function addImportPersonalTaxCompanyBurden(data) {
  return request({
    url: '/salary/importPersonalTaxCompanyBurden',
    method: 'post',
    data: data
  })
}

// 修改个税公司负担
export function updateImportPersonalTaxCompanyBurden(data) {
  return request({
    url: '/salary/importPersonalTaxCompanyBurden/edit',
    method: 'post',
    data: data
  })
}

// 删除个税公司负担
export function delImportPersonalTaxCompanyBurden(id) {
  return request({
    url: '/salary/importPersonalTaxCompanyBurden/delete',
    method: 'post',
    data: id
  })
}
