import request from '@/utils/request'

// 查询厂区社保员工统计列表
export function listImportSocialInsurance(query) {
  return request({
    url: '/salary/importSocialInsurance/list',
    method: 'get',
    params: query
  })
}

// 查询厂区社保员工统计详细
export function getImportSocialInsurance(id) {
  return request({
    url: '/salary/importSocialInsurance/' + id,
    method: 'get'
  })
}

// 新增厂区社保员工统计
export function addImportSocialInsurance(data) {
  return request({
    url: '/salary/importSocialInsurance',
    method: 'post',
    data: data
  })
}

// 修改厂区社保员工统计
export function updateImportSocialInsurance(data) {
  return request({
    url: '/salary/importSocialInsurance/edit',
    method: 'post',
    data: data
  })
}

// 删除厂区社保员工统计
export function delImportSocialInsurance(id) {
  return request({
    url: '/salary/importSocialInsurance/delete',
    method: 'post',
    data: id
  })
}

// 删除厂区社保员工统计
export function copy2NextMonth(data) {
  return request({
    url: '/salary/importSocialInsurance/copy2NextMonth',
    method: 'post',
    data: data
  })
}
