import request from '@/utils/request'

// 查询工资项管理列表
export function listItemManager(query) {
  return request({
    url: '/salary/itemManager/list',
    method: 'get',
    params: query
  })
}

// 查询工资项管理详细
export function getItemManager(id) {
  return request({
    url: '/salary/itemManager/' + id,
    method: 'get'
  })
}

// 新增工资项管理
export function addItemManager(data) {
  return request({
    url: '/salary/itemManager',
    method: 'post',
    data: data
  })
}

// 修改工资项管理
export function updateItemManager(data) {
  return request({
    url: '/salary/itemManager/edit',
    method: 'post',
    data: data
  })
}

// 删除工资项管理
export function delItemManager(id) {
  return request({
    url: '/salary/itemManager/delete',
    method: 'post',
    data: id
  })
}
