import request from '@/utils/request'

// 查询工资方案 - 基础信息列表
export function listPlanBase(query) {
  return request({
    url: '/salary/planBase/list',
    method: 'get',
    params: query
  })
}

// 查询工资方案 - 基础信息详细
export function getPlanBase(id) {
  return request({
    url: '/salary/planBase/' + id,
    method: 'get'
  })
}

// 新增工资方案 - 基础信息
export function addPlanBase(data) {
  return request({
    url: '/salary/planBase',
    method: 'post',
    data: data
  })
}

// 修改工资方案 - 基础信息
export function updatePlanBase(data) {
  return request({
    url: '/salary/planBase/edit',
    method: 'post',
    data: data
  })
}

// 删除工资方案 - 基础信息
export function delPlanBase(id) {
  return request({
    url: '/salary/planBase/delete',
    method: 'post',
    data: id
  })
}
