import request from '@/utils/request'

// 查询工资计算列表
export function listPlanCalc(query) {
  return request({
    url: '/salary/planCalc/list',
    method: 'get',
    params: query
  })
}

// 查询工资计算详细
export function getPlanCalc(id) {
  return request({
    url: '/salary/planCalc/' + id,
    method: 'get'
  })
}

// 新增工资计算
export function addPlanCalc(data) {
  return request({
    url: '/salary/planCalc',
    method: 'post',
    data: data
  })
}

// 修改工资计算
export function updatePlanCalc(data) {
  return request({
    url: '/salary/planCalc/edit',
    method: 'post',
    data: data
  })
}

// 删除工资计算
export function delPlanCalc(id) {
  return request({
    url: '/salary/planCalc/delete',
    method: 'post',
    data: id
  })
}

export function getEmployeesByPlan(query) {
  return request({
    url: '/salary/planCalc/getEmployeesByPlan',
    method: 'get',
    params: query
  })
}

export function checkImport(data) {
  return request({
    url: '/salary/planCalc/checkImport',
    method: 'post',
    data: data
  })
}

// 开始工资计算
export function startCalcSalary(data) {
  return request({
    url: '/salary/planCalc/startCalcSalary',
    method: 'post',
    data: data
  })
}

export function recalculateSalary(data) {
  return request({
    url: '/salary/planCalc/recalculateSalary',
    method: 'post',
    data: data
  })
}

export function editSalaryRow(data) {
  return request({
    url: '/salary/planCalc/editSalaryRow',
    method: 'post',
    data: data
  })
}

export function getMonthTotalSalary(query) {
  return request({
    url: '/salary/planCalc/getMonthTotalSalary',
    method: 'get',
    params: query
  })
}

export function getAllSalaryByCalcId(query) {
  return request({
    url: '/salary/planCalc/getAllSalaryByCalcId',
    method: 'get',
    params: query
  })
}

export function getPenetratingData(data) {
  return request({
    url: '/salary/planCalc/getPenetratingData',
    method: 'post',
    data: data
  })
}

export function startAudit(data) {
  return request({
    url: '/salary/planCalc/startAudit',
    method: 'post',
    data: data
  })
}

export function startSalaryEsign(data) {
  return request({
    url: '/salary/planCalc/startSalaryEsign',
    method: 'post',
    data: data
  })
}

export function selectEsignList(query) {
  return request({
    url: '/salary/planCalc/selectEsignList',
    method: 'get',
    params: query
  })
}
