import request from '@/utils/request'

// 查询工资方案 - 工资项列表
export function listPlanItem(query) {
  return request({
    url: '/salary/planItem/list',
    method: 'get',
    params: query
  })
}

// 查询工资方案 - 工资项详细
export function getPlanItem(id) {
  return request({
    url: '/salary/planItem/' + id,
    method: 'get'
  })
}

// 新增工资方案 - 工资项
export function addPlanItem(data) {
  return request({
    url: '/salary/planItem',
    method: 'post',
    data: data
  })
}

// 修改工资方案 - 工资项
export function updatePlanItem(data) {
  return request({
    url: '/salary/planItem/edit',
    method: 'post',
    data: data
  })
}

// 删除工资方案 - 工资项
export function delPlanItem(id) {
  return request({
    url: '/salary/planItem/delete',
    method: 'post',
    data: id
  })
}
