import request from '@/utils/request'

// 查询工资方案管理列表
export function listPlans(query) {
  return request({
    url: '/salary/plans/list',
    method: 'get',
    params: query
  })
}

// 查询工资方案管理详细
export function getPlans(id) {
  return request({
    url: '/salary/plans/' + id,
    method: 'get'
  })
}

// 新增工资方案管理
export function addPlans(data) {
  return request({
    url: '/salary/plans',
    method: 'post',
    data: data
  })
}

// 修改工资方案管理
export function updatePlans(data) {
  return request({
    url: '/salary/plans/edit',
    method: 'post',
    data: data
  })
}

// 删除工资方案管理
export function delPlans(id) {
  return request({
    url: '/salary/plans/delete',
    method: 'post',
    data: id
  })
}

export function employeeList(data) {
  return request({
    url: '/salary/plans/employeeList',
    method: 'post',
    data: data
  })
}

export function addExcludeEmployeeList(data) {
  return request({
    url: '/salary/plans/addExcludeEmployeeList',
    method: 'post',
    data: data
  })
}

export function addIncludeEmployeeList(data) {
  return request({
    url: '/salary/plans/addIncludeEmployeeList',
    method: 'post',
    data: data
  })
}

export function includeEmployeeList(data) {
  return request({
    url: '/salary/plans/includeEmployeeList',
    method: 'post',
    data: data
  })
}

export function enabledStatus(data) {
  return request({
    url: '/salary/plans/enabledStatus',
    method: 'post',
    data: data
  })
}
