import request from '@/utils/request'

// 查询销售社保地区统计列表
export function listSocialInsuranceArea(query) {
  return request({
    url: '/salary/socialInsuranceArea/list',
    method: 'get',
    params: query
  })
}

// 查询销售社保地区统计详细
export function getSocialInsuranceArea(id) {
  return request({
    url: '/salary/socialInsuranceArea/' + id,
    method: 'get'
  })
}

// 新增销售社保地区统计
export function addSocialInsuranceArea(data) {
  return request({
    url: '/salary/socialInsuranceArea',
    method: 'post',
    data: data
  })
}

// 修改销售社保地区统计
export function updateSocialInsuranceArea(data) {
  return request({
    url: '/salary/socialInsuranceArea/edit',
    method: 'post',
    data: data
  })
}

// 删除销售社保地区统计
export function delSocialInsuranceArea(id) {
  return request({
    url: '/salary/socialInsuranceArea/delete',
    method: 'post',
    data: id
  })
}
