import request from '@/utils/request'

// 查询销售社保员工统计列表
export function listSocialInsurancePeople(query) {
  return request({
    url: '/salary/socialInsurancePeople/list',
    method: 'get',
    params: query
  })
}

// 查询销售社保员工统计详细
export function getSocialInsurancePeople(id) {
  return request({
    url: '/salary/socialInsurancePeople/' + id,
    method: 'get'
  })
}

// 新增销售社保员工统计
export function addSocialInsurancePeople(data) {
  return request({
    url: '/salary/socialInsurancePeople',
    method: 'post',
    data: data
  })
}

// 修改销售社保员工统计
export function updateSocialInsurancePeople(data) {
  return request({
    url: '/salary/socialInsurancePeople/edit',
    method: 'post',
    data: data
  })
}

// 删除销售社保员工统计
export function delSocialInsurancePeople(id) {
  return request({
    url: '/salary/socialInsurancePeople/delete',
    method: 'post',
    data: id
  })
}

export function copy2NextMonth(data) {
  return request({
    url: '/salary/socialInsurancePeople/copy2NextMonth',
    method: 'post',
    data: data
  })
}