import request from '@/utils/request'

// 查询个税专项扣除列表
export function listTaxDeduction(query) {
  return request({
    url: '/salary/taxDeduction/list',
    method: 'get',
    params: query
  })
}

// 查询个税专项扣除详细
export function getTaxDeduction(id) {
  return request({
    url: '/salary/taxDeduction/' + id,
    method: 'get'
  })
}

// 新增个税专项扣除
export function addTaxDeduction(data) {
  return request({
    url: '/salary/taxDeduction',
    method: 'post',
    data: data
  })
}

// 修改个税专项扣除
export function updateTaxDeduction(data) {
  return request({
    url: '/salary/taxDeduction/edit',
    method: 'post',
    data: data
  })
}

// 删除个税专项扣除
export function delTaxDeduction(id) {
  return request({
    url: '/salary/taxDeduction/delete',
    method: 'post',
    data: id
  })
}
