import request from '@/utils/request'

// 查询薪资补贴调整金额列表
export function listWageSubsidy(query) {
  return request({
    url: '/salary/wageSubsidy/list',
    method: 'get',
    params: query
  })
}

// 查询薪资补贴调整金额详细
export function getWageSubsidy(id) {
  return request({
    url: '/salary/wageSubsidy/' + id,
    method: 'get'
  })
}

// 新增薪资补贴调整金额
export function addWageSubsidy(data) {
  return request({
    url: '/salary/wageSubsidy',
    method: 'post',
    data: data
  })
}

// 修改薪资补贴调整金额
export function updateWageSubsidy(data) {
  return request({
    url: '/salary/wageSubsidy/edit',
    method: 'post',
    data: data
  })
}

// 删除薪资补贴调整金额
export function delWageSubsidy(id) {
  return request({
    url: '/salary/wageSubsidy/delete',
    method: 'post',
    data: id
  })
}
