import request from '@/utils/request'

/**
 * 更新便捷菜单
 * @param {any} data
 * @param {string|number} data.menuId 菜单ID
 * @param {number} data.sort 排序 起始1
 * @param {string} data.fastType 1菜单，2外链
 * @param {string} data.linkName // 外链名称
 * @param {string} data.linkUrl 外链url
 * @param {string} data.icon icon字符串
 */
export function updateList(data) {
  return request({
    url: '/system/sysUserFastMenu/updateList',
    method: 'post',
    data: data
  })
}

/**
 * 查询个人快捷菜单
 */
export function getListByLoginUser() {
  return request({
    url: '/system/sysUserFastMenu/getListByLoginUser',
    method: 'get'
  })
}

/**
 * 首页右侧接口
 */
export function userStickers() {
  return request({
    url: '/system/sysUserFastMenu/userStickers',
    method: 'get'
  })
}

/**
 * 首页折线图接口
 */
export function jxLineChart() {
  return request({
    url: '/system/sysUserFastMenu/jxLineChart',
    method: 'get'
  })
}

/**
 * 首页雷达图接口
 */
export function jxRadarChart() {
  return request({
    url: '/system/sysUserFastMenu/jxRadarChart',
    method: 'get'
  })
}
