import request from '@/utils/request'

// 查询公司信息表列表
export function listCompanyInfo(query) {
  return request({
    url: '/system/companyInfo/list',
    method: 'get',
    params: query
  })
}

// 查询公司信息表详细
export function getCompanyInfo(id) {
  return request({
    url: '/system/companyInfo/' + id,
    method: 'get'
  })
}

// 新增公司信息表
export function addCompanyInfo(data) {
  return request({
    url: '/system/companyInfo',
    method: 'post',
    data: data
  })
}

// 修改公司信息表
export function updateCompanyInfo(data) {
  return request({
    url: '/system/companyInfo/edit',
    method: 'post',
    data: data
  })
}

// 删除公司信息表
export function delCompanyInfo(id) {
  return request({
    url: '/system/companyInfo/delete/' + id,
    method: 'post'
  })
}
