import request from '@/utils/request'

// 查询数据权限列表
export function listDatascope(query) {
  return request({
    url: '/system/datascope/list',
    method: 'get',
    params: query
  })
}

// 查询数据权限详细
export function getDatascope(id) {
  return request({
    url: '/system/datascope/' + id,
    method: 'get'
  })
}

// 新增数据权限
export function addDatascope(data) {
  return request({
    url: '/system/datascope',
    method: 'post',
    data: data
  })
}

// 修改数据权限
export function updateDatascope(data) {
  return request({
    url: '/system/datascope/edit',
    method: 'post',
    data: data
  })
}

// 删除数据权限
export function delDatascope(id) {
  return request({
    url: '/system/datascope/delete',
    method: 'post',
    data: id
  })
}

// 查询数据权限列表
export function datascopeTree(query) {
  return request({
    url: '/system/datascope/datascopeTree',
    method: 'get',
    params: query
  })
}
