import request from '@/utils/request'

// 查询部门列表
export function listDept(query) {
  return request({
    url: '/system/dept/list',
    method: 'get',
    params: query
  })
}

// 查询部门列表（排除节点）
export function listDeptExcludeChild(deptId) {
  return request({
    url: '/system/dept/list/exclude/' + deptId,
    method: 'get'
  })
}

// 查询部门详细
export function getDept(deptId) {
  return request({
    url: '/system/dept/' + deptId,
    method: 'get'
  })
}

// 新增部门
export function addDept(data) {
  return request({
    url: '/system/dept',
    method: 'post',
    data: data
  })
}

// 修改部门
export function updateDept(data) {
  return request({
    url: '/system/dept/edit',
    method: 'post',
    data: data
  })
}

// 删除部门
export function delDept(deptId) {
  return request({
    url: '/system/dept/delete/' + deptId,
    method: 'post'
  })
}


/**
 * 获取所有岗位列表
 */
export function allPostListpost() {
  return request({
    url: '/system/post/allPostList',
    method: 'post'
  })
}

/**
 * 查询部门下岗位列表
 * @param {number|string|undefined} deptId 部门id
 */
export function queryDeptNextPostList(deptId) {
  return request({
    url: '/system/dept/queryDeptNextPostList',
    method: 'post',
    data: { deptId }
  })
}

/**
 * 查询部门下已选岗位列表
 * @param {number|string|undefined} deptId 部门id
 */
export function selectDeptNextDirectPostInfo(deptId) {
  return request({
    url: '/system/dept/selectDeptNextDirectPostInfo',
    method: 'post',
    data: { deptId }
  })
}

/**
 * 查询部门统计信息
 * @param {number|string|undefined} deptId 部门id
 */
export function queryDeptNextToalInfo(deptId) {
  return request({
    url: '/system/dept/queryDeptNextToalInfo',
    method: 'post',
    data: { deptId }
  })
}

/**
 * 增加部门下岗位信息
 * @param {number|string|undefined} deptId 部门id
 * @param {number[]|string[]} postIdList 岗位id
 */
export function insertDeptNextPostInfo(data) {
  return request({
    url: '/system/dept/insertDeptNextPostInfo',
    method: 'post',
    data: data
  })
}

/**
 * 更新排序
 * @param {Array<{ deptId: string, parentId: string: orderNum: number}>} list 部门id
 */
export function changeDeptLevel(data) {
  return request({
    url: '/system/dept/changeDeptLevel',
    method: 'post',
    data: data
  })
}

// 根据部门ID查询所属公司Code
export function getDeptParentCompanyCode(query) {
  return request({
    url: '/system/dept/getDeptParentCompanyCode',
    method: 'get',
    params: query
  })
}

/**
 * 部门下所有员工列表
 * @param {Object} query
 * @param {number} query.pageNum
 * @param {number} query.pageSize
 * @param {string} query.month 月份 非必传
 * @param {string} query.deptId 部门id 必传
 * @param {string} query.ratingKpi 绩效等级 非必传
 * @returns
 */
export function getAllEmployeesInfoInDeptId(query) {
  return request({
    url: '/system/dept/getAllEmployeesInfoInDeptId',
    method: 'get',
    params: query
  })
}

/**
 * 部门下直属员工列表
 * @param {Object} query
 * @param {number} query.pageNum
 * @param {number} query.pageSize
 * @param {string} query.month 月份 非必传
 * @param {string} query.deptId 部门id 必传
 * @param {string} query.ratingKpi 绩效等级 非必传
 * @returns
 */
export function getSubEmployeesInfoInDeptId(query) {
  return request({
    url: '/system/dept/getSubEmployeesInfoInDeptId',
    method: 'get',
    params: query
  })
}

/**
 * 部门绩效排名
 * @param {Object} query
 * @param {string} query.month 月份 非必传
 * @param {string} query.deptId 部门id 必传
 * @returns
 */
export function getKpiRankingByDeptId(query) {
  return request({
    url: '/system/dept/getKpiRankingByDeptId',
    method: 'get',
    params: query
  })
}

// 获取部门下所有子部门ID
export function getChildrenDeptIds(data) {
  return request({
    url: '/system/dept/getChildrenDeptIds',
    method: 'post',
    data: data
  })
}

// 修改部门
export function updateHeadconut(data) {
  return request({
    url: '/system/dept/updateHeadconut',
    method: 'post',
    data: data
  })
}