import request from '@/utils/request'

// 查询工厂职等职级列表
export function listFactoryGradeRank(query) {
  return request({
    url: '/system/factoryGradeRank/list',
    method: 'get',
    params: query
  })
}

// 查询工厂职等职级详细
export function getFactoryGradeRank(id) {
  return request({
    url: '/system/factoryGradeRank/' + id,
    method: 'get'
  })
}

// 新增工厂职等职级
export function addFactoryGradeRank(data) {
  return request({
    url: '/system/factoryGradeRank',
    method: 'post',
    data: data
  })
}

// 修改工厂职等职级
export function updateFactoryGradeRank(data) {
  return request({
    url: '/system/factoryGradeRank/edit',
    method: 'post',
    data: data
  })
}

// 删除工厂职等职级
export function delFactoryGradeRank(id) {
  return request({
    url: '/system/factoryGradeRank/delete/' + id,
    method: 'post'
  })
}
