import request from '@/utils/request'

// 查询营销公司职等职级列表
export function listGRADE(query) {
  return request({
    url: '/system/jobGrade/list',
    method: 'get',
    params: query
  })
}

// 查询营销公司职等职级详细
export function getGRADE(id) {
  return request({
    url: '/system/jobGrade/' + id,
    method: 'get'
  })
}

// 新增营销公司职等职级
export function addGRADE(data) {
  return request({
    url: '/system/jobGrade',
    method: 'post',
    data: data
  })
}

// 修改营销公司职等职级
export function updateGRADE(data) {
  return request({
    url: '/system/jobGrade/edit',
    method: 'post',
    data: data
  })
}

// 删除营销公司职等职级
export function delGRADE(id) {
  return request({
    url: '/system/jobGrade/delete/' + id,
    method: 'post'
  })
}
