import request from '@/utils/request'

// 查询邮件模版列表
export function listMailTemplate(query) {
  return request({
    url: '/system/mailTemplate/list',
    method: 'get',
    params: query
  })
}

// 查询邮件模版详细
export function getMailTemplate(id) {
  return request({
    url: '/system/mailTemplate/' + id,
    method: 'get'
  })
}

// 新增邮件模版
export function addMailTemplate(data) {
  return request({
    url: '/system/mailTemplate',
    method: 'post',
    data: data
  })
}

// 修改邮件模版
export function updateMailTemplate(data) {
  return request({
    url: '/system/mailTemplate/edit',
    method: 'post',
    data: data
  })
}

// 删除邮件模版
export function delMailTemplate(id) {
  return request({
    url: '/system/mailTemplate/delete/' + id,
    method: 'post'
  })
}
