import request from '@/utils/request'

// 查询模块功能引导管理列表
export function listModulePrompt(query) {
  return request({
    url: '/system/modulePrompt/list',
    method: 'get',
    params: query
  })
}

// 查询模块功能引导管理详细
export function getModulePrompt(id) {
  return request({
    url: '/system/modulePrompt/' + id,
    method: 'get'
  })
}

// 新增模块功能引导管理
export function addModulePrompt(data) {
  return request({
    url: '/system/modulePrompt',
    method: 'post',
    data: data
  })
}

// 修改模块功能引导管理
export function updateModulePrompt(data) {
  return request({
    url: '/system/modulePrompt/edit',
    method: 'post',
    data: data
  })
}

// 删除模块功能引导管理
export function delModulePrompt(id) {
  return request({
    url: '/system/modulePrompt/delete/' + id,
    method: 'post'
  })
}
