import request from '@/utils/request'

// 查询短信模版列表
export function listSmsTemplate(query) {
  return request({
    url: '/system/smsTemplate/list',
    method: 'get',
    params: query
  })
}

// 查询短信模版详细
export function getSmsTemplate(id) {
  return request({
    url: '/system/smsTemplate/' + id,
    method: 'get'
  })
}

// 新增短信模版
export function addSmsTemplate(data) {
  return request({
    url: '/system/smsTemplate',
    method: 'post',
    data: data
  })
}

// 修改短信模版
export function updateSmsTemplate(data) {
  return request({
    url: '/system/smsTemplate/edit',
    method: 'post',
    data: data
  })
}

// 删除短信模版
export function delSmsTemplate(id) {
  return request({
    url: '/system/smsTemplate/delete/' + id,
    method: 'post'
  })
}
