import request from '@/utils/request'

// 查询数据权限详情列表
export function listSysDatascopeDetail(query) {
  return request({
    url: '/system/sysDatascopeDetail/list',
    method: 'get',
    params: query
  })
}

// 查询数据权限详情详细
export function getSysDatascopeDetail(id) {
  return request({
    url: '/system/sysDatascopeDetail/' + id,
    method: 'get'
  })
}

// 新增数据权限详情
export function addSysDatascopeDetail(data) {
  return request({
    url: '/system/sysDatascopeDetail',
    method: 'post',
    data: data
  })
}

// 修改数据权限详情
export function updateSysDatascopeDetail(data) {
  return request({
    url: '/system/sysDatascopeDetail/edit',
    method: 'post',
    data: data
  })
}

// 删除数据权限详情
export function delSysDatascopeDetail(id) {
  return request({
    url: '/system/sysDatascopeDetail/delete',
    method: 'post',
    data: id
  })
}
