import request from '@/utils/request'

// 查询角色-数据权限列表
export function listSysRoleDatascope(query) {
  return request({
    url: '/system/sysRoleDatascope/list',
    method: 'get',
    params: query
  })
}

// 查询角色-数据权限详细
export function getSysRoleDatascope(id) {
  return request({
    url: '/system/sysRoleDatascope/' + id,
    method: 'get'
  })
}

// 新增角色-数据权限
export function addSysRoleDatascope(data) {
  return request({
    url: '/system/sysRoleDatascope',
    method: 'post',
    data: data
  })
}

// 修改角色-数据权限
export function updateSysRoleDatascope(data) {
  return request({
    url: '/system/sysRoleDatascope/edit',
    method: 'post',
    data: data
  })
}

// 删除角色-数据权限
export function delSysRoleDatascope(id) {
  return request({
    url: '/system/sysRoleDatascope/delete',
    method: 'post',
    data: id
  })
}

export function getDataScopeIdListByRoleId(query) {
  return request({
    url: '/system/sysRoleDatascope/getDataScopeIdListByRoleId',
    method: 'get',
    params: query
  })
}
