import request from '@/utils/request'

// 查询短信邮件的模版参数列表
export function listTemplateParameters(query) {
  return request({
    url: '/system/templateParameters/list',
    method: 'get',
    params: query
  })
}

// 查询短信邮件的模版参数详细
export function getTemplateParameter(id) {
  return request({
    url: '/system/templateParameters/' + id,
    method: 'get'
  })
}

// 新增短信邮件的模版参数
export function addTemplateParameter(data) {
  return request({
    url: '/system/templateParameters',
    method: 'post',
    data: data
  })
}

// 修改短信邮件的模版参数
export function updateTemplateParameter(data) {
  return request({
    url: '/system/templateParameters/edit',
    method: 'post',
    data: data
  })
}

// 删除短信邮件的模版参数
export function delTemplateParameters(id) {
  return request({
    url: '/system/templateParameters/delete/' + id,
    method: 'post'
  })
}
