import request from '@/utils/request'

// 查询租户信息列表
export function listTENANT(query) {
  return request({
    url: '/system/tenant/list',
    method: 'get',
    params: query
  })
}

// 查询租户信息详细
export function getTENANT(id) {
  return request({
    url: '/system/tenant/' + id,
    method: 'get'
  })
}

// 新增租户信息
export function addTENANT(data) {
  return request({
    url: '/system/tenant',
    method: 'post',
    data: data
  })
}

// 修改租户信息
export function updateTENANT(data) {
  return request({
    url: '/system/tenant/edit',
    method: 'post',
    data: data
  })
}

// 删除租户信息
export function delTENANT(id) {
  return request({
    url: '/system/tenant/delete',
    method: 'post',
    data: id
  })
}
// 批量初始化密码
export function initTenantPassword(ids) {
  return request({
    url: '/system/tenant/initTenantPassword',
    method: 'post',
    data: ids
  })
}
// 查询租户下 可以分配的菜单权限
export function selectTenantMenuList(data) {
  return request({
    url: '/system/tenant/selectTenantAuthMenuList',
    method: 'post',
    data: data
  })
}
// 插入分配的菜单权限
export function addTenantMenu(data) {
  return request({
    url: '/system/tenant/addTenantMenu',
    method: 'post',
    data: data
  })
}
