import request from '@/utils/request'
import { parseStrEmpty } from '@/utils/ruoyi'

// 查询用户列表
export function listUser(query) {
  return request({
    url: '/system/user/list',
    method: 'get',
    params: query
  })
}
// 查询用户列表
export function userAll(query) {
  return request({

    url: '/system/user/userAll',
    method: 'get',
    params: query
  })
}
// 查询用户详细
export function getUser(userId) {
  return request({
    url: '/system/user/' + parseStrEmpty(userId),
    method: 'get'
  })
}

// 新增用户
export function addUser(data) {
  return request({
    url: '/system/user',
    method: 'post',
    data: data
  })
}

// 修改用户
export function updateUser(data) {
  return request({
    url: '/system/user/edit',
    method: 'post',
    data: data
  })
}

/**
 * 重置工资密码
 * @param data
 * @returns {*}
 */
export function resetSalaryPassword(data) {
  return request({
    url: '/system/user/resetSalaryPassword',
    method: 'post',
    data: data
  })
}

// 删除用户
export function delUser(userId) {
  return request({
    url: '/system/user/delete/' + userId,
    method: 'post'
  })
}

// 用户密码重置
export function resetUserPwd(userId, password) {
  const data = {
    userId,
    password
  }
  return request({
    url: '/system/user/resetPwd',
    method: 'post',
    data: data
  })
}

// 用户状态修改
export function changeUserStatus(userId, status) {
  const data = {
    userId,
    status
  }
  return request({
    url: '/system/user/changeStatus',
    method: 'post',
    data: data
  })
}

// 查询用户个人信息
export function getUserProfile() {
  return request({
    url: '/system/user/profile',
    method: 'get'
  })
}

// 修改用户个人信息
export function updateUserProfile(data) {
  return request({
    url: '/system/user/profile/edit',
    method: 'post',
    data: data
  })
}

// 用户密码重置
export function updateUserPwd(oldPassword, newPassword) {
  const data = {
    oldPassword,
    newPassword
  }
  return request({
    url: '/system/user/profile/updatePwd',
    method: 'post',
    params: data
  })
}

// 用户头像上传
export function uploadAvatar(data) {
  return request({
    headers: { 'Content-Type': 'mulipart/form-data' },
    url: '/system/user/profile/avatar',
    method: 'post',
    data: data
  })
}

// 头像上传
export function uploadAvatarOther(data) {
  return request({
    headers: { 'Content-Type': 'mulipart/form-data' },
    url: '/system/user/profile/avatarOther',
    method: 'post',
    data: data
  })
}

// 查询授权角色
export function getAuthRole(userId) {
  return request({
    url: '/system/user/authRole/' + userId,
    method: 'get'
  })
}

// 保存授权角色
export function updateAuthRole(data) {
  return request({
    url: '/system/user/authRole',
    method: 'post',
    params: data
  })
}

// 查询部门下拉树结构
export function deptTreeSelect() {
  return request({
    url: '/system/user/deptTree',
    method: 'get'
  })
}

// 查询归属部门下拉树结构
export function selectDeptTreeListToComponent(data) {
  return request({
    url: '/system/dept/selectDeptTreeListToComponent',
    method: 'post',
    data: data
  })
}

// 查询岗位
export function selectPostToComponent(data) {
  return request({
    url: '/system/post/selectPostToComponent',
    method: 'POST',
    data: data
  })
}

// 查询角色
export function selectAllUserToComponent(data) {
  return request({
    url: '/system/user/selectAllUserToComponent',
    method: 'POST',
    data: data
  })
}

// 查询所属公司
export function queryCompanyList(data) {
  return request({
    url: '/system/companyInfo/queryCompanyList',
    method: 'POST',
    data: data
  })
}


// 查询所有员工
export function selectDeptNextEmployeesInfoTreeList(data) {
  return request({
    url: '/system/user/selectDeptNextEmployeesInfoTreeList',
    method: 'POST',
    data: data
  })
}

// 查询所有sys_user用户
export function selectDeptNextUserInfoTreeList(data) {
  return request({
    url: '/system/user/selectDeptNextUserInfoTreeList',
    method: 'POST',
    data: data
  })
}

// 根据员工工号查询 表pm_employees 员工信息
export function selectEmployeesInfoByCode(data) {
  return request({
    url: '/system/user/selectEmployeesInfoByCode',
    method: 'POST',
    params: data
  })
}
// 根据部门数组查询人员（去重）
export function selectUserByDeptId(data) {
  return request({
    url: '/system/user/selectUserByDeptId',
    method: 'POST',
    data: data
  })
}
// 根据岗位数组查询人员（去重）
export function selectUserByPostId(data) {
  return request({
    url: '/system/user/selectUserByPostId',
    method: 'POST',
    data: data
  })
}
