import request from '@/utils/request'

// 查询随访人员列表
export function listVisitorFollow(query) {
  return request({
    url: '/system/visitorFollow/list',
    method: 'get',
    params: query
  })
}

// 查询随访人员详细
export function getVisitorFollow(id) {
  return request({
    url: '/system/visitorFollow/' + id,
    method: 'get'
  })
}

// 新增随访人员
export function addVisitorFollow(data) {
  return request({
    url: '/system/visitorFollow',
    method: 'post',
    data: data
  })
}

// 修改随访人员
export function updateVisitorFollow(data) {
  return request({
    url: '/system/visitorFollow/edit',
    method: 'post',
    data: data
  })
}

// 删除随访人员
export function delVisitorFollow(id) {
  return request({
    url: '/system/visitorFollow/delete/' + id,
    method: 'post'
  })
}
