import request from '@/utils/request'

// 查询访客管理列表
export function listVisitorManage(query) {
  return request({
    url: '/system/visitorManage/list',
    method: 'get',
    params: query
  })
}

// 查询访客管理详细
export function getVisitorManage(id) {
  return request({
    url: '/system/visitorManage/' + id,
    method: 'get'
  })
}

// 新增访客管理
export function addVisitorManage(data) {
  return request({
    url: '/system/visitorManage',
    method: 'post',
    data: data
  })
}

// 修改访客管理
export function updateVisitorManage(data) {
  return request({
    url: '/system/visitorManage/edit',
    method: 'post',
    data: data
  })
}

// 删除访客管理
export function delVisitorManage(id) {
  return request({
    url: '/system/visitorManage/delete/' + id,
    method: 'post'
  })
}

// 更新接待时间和状态
export function updateReceiverTime(data) {
  return request({
    url: '/system/visitorManage/updateReceiverTime',
    method: 'post',
    data: data
  })
}

// 查询访客管理门卫列表
export function listVisitorManageEntrance(query) {
  return request({
    url: '/system/visitorManage/entranceList',
    method: 'get',
    params: query
  })
}

// 更新随访人员房间号
export function updateVisitorReception(data) {
  return request({
    url: '/system/visitorManage/reception/edit',
    method: 'post',
    data: data
  })
}

// 拍照
export function takePhoto(data) {
  return request({
    url: '/system/visitorManage/takePhoto',
    method: 'post',
    data: data
  })
}

// 拍照上传
export function takePhotoUpload(data) {
  return request({
    url: '/system/visitorManage/takePhotoUpload',
    method: 'post',
    data: data
  })
}
