import request from '@/utils/request'

// 查询工作台管理列表
export function listWorkGalleryManage(query) {
  return request({
    url: '/system/workGalleryManage/list',
    method: 'get',
    params: query
  })
}

// 查询工作台管理详细
export function getWorkGalleryManage(id) {
  return request({
    url: '/system/workGalleryManage/' + id,
    method: 'get'
  })
}

// 新增工作台管理
export function addWorkGalleryManage(data) {
  return request({
    url: '/system/workGalleryManage',
    method: 'post',
    data: data
  })
}

// 修改工作台管理
export function updateWorkGalleryManage(data) {
  return request({
    url: '/system/workGalleryManage/edit',
    method: 'post',
    data: data
  })
}

// 删除工作台管理
export function delWorkGalleryManage(id) {
  return request({
    url: '/system/workGalleryManage/delete/' + id,
    method: 'post'
  })
}
