import request from '@/utils/request'

// 查询培训课程列表
export function listTmTrainCourse(query) {
  return request({
    url: '/train/TmTrainCourse/list',
    method: 'get',
    params: query
  })
}

// 查询培训课程详细
export function getTmTrainCourse(id) {
  return request({
    url: '/train/TmTrainCourse/' + id,
    method: 'get'
  })
}

// 新增培训课程
export function addTmTrainCourse(data) {
  return request({
    url: '/train/TmTrainCourse',
    method: 'post',
    data: data
  })
}

// 修改培训课程
export function updateTmTrainCourse(data) {
  return request({
    url: '/train/TmTrainCourse/edit',
    method: 'post',
    data: data
  })
}

// 删除培训课程
export function delTmTrainCourse(id) {
  return request({
    url: '/train/TmTrainCourse/delete/' + id,
    method: 'post'
  })
}

// 新增培训课程
export function insertTmTrainCourseAndFileList(data) {
  return request({
    url: '/train/TmTrainCourse/insertTmTrainCourseAndFileList',
    method: 'post',
    data: data
  })
}


// 查询培训课程列表
export function myCourselist(query) {
  return request({
    url: '/train/TmTrainCourse/myCourselist',
    method: 'get',
    params: query
  })
}


// 查询培训课程列表
export function listByTrainId(query) {
  return request({
    url: '/train/TmTrainCourse/listByTrainId',
    method: 'get',
    params: query
  })
}


// 培训课程小节列表
export function listTmCourseSection(query) {
  return request({
    url: '/train/TmCourseSection/list',
    method: 'get',
    params: query
  })
}

// 获取培训视频线路列表
export function getStreamList(query) {
  return request({
    url: '/train/file/streamList',
    method: 'get',
    params: query
  })
}
