import request from '@/utils/request'

// 查询培训计划列表
export function listTmTrainPlan(query) {
  return request({
    url: '/train/TmTrainPlan/list',
    method: 'get',
    params: query
  })
}
// 查询培训计划列表
export function listByTrainId(data) {
  return request({
    url: '/train/TmTrainPlan/listByTrainId',
    method: 'post',
    data: data
  })
}

// 查询培训计划详细
export function getTmTrainPlan(id) {
  return request({
    url: '/train/TmTrainPlan/' + id,
    method: 'get'
  })
}

// 查询培训学习记录详细
export function getUserListByTrainId(id) {
  return request({
    url: '/train/TmTrainPlan/userList/' + id,
    method: 'get'
  })
}

// 新增培训计划
export function addTmTrainPlan(data) {
  return request({
    url: '/train/TmTrainPlan',
    method: 'post',
    data: data
  })
}

// 修改培训计划(当前单表)
export function updateTmTrainPlanEdit(data) {
  return request({
    url: '/train/TmTrainPlan/planEdit',
    method: 'post',
    data: data
  })
}

// 培训计划关联课程
export function updateTmTrainRelateCourse(data) {
  return request({
    url: '/train/TmTrainPlan/relateCourse',
    method: 'post',
    data: data
  })
}


// 修改培训计划
export function updateTmTrainPlan(data) {
  return request({
    url: '/train/TmTrainPlan/edit',
    method: 'post',
    data: data
  })
}


// 修改培训计划
export function tmTrainPlanFeedBack(data) {
  return request({
    url: '/train/TmTrainPlan/feedBack',
    method: 'post',
    data: data
  })
}

// 删除培训计划
export function delTmTrainPlan(id) {
  return request({
    url: '/train/TmTrainPlan/delete/' + id,
    method: 'post'
  })
}


// 查询培训计划列表
export function myPlanlist(query) {
  return request({
    url: '/train/TmTrainPlan/myPlanlist',
    method: 'get',
    params: query
  })
}


// 查询培训计划列表
export function selectUserByDeptId(data) {
  return request({
    url: '/system/user/selectUserByDeptId',
    method: 'post',
    data: data
  })
}

// 根据岗位数组查询人员（去重）
export function selectUserByPostId(idList, deptId) {
  return request({
    url: '/system/user/selectUserByPostId/' + idList + '&' + deptId,
    method: 'get'
  })
}

// 添加培训人员
export function addTrainPeople(data) {
  return request({
    url: '/train/TmTrainPlan/addTrainPeople',
    method: 'post',
    data: data
  })
}
