import request from '@/utils/request'

// 查询培训学习记录列表
export function listTmTrainRecord(query) {
  return request({
    url: '/train/TmTrainRecord/list',
    method: 'get',
    params: query
  })
}

// 查询培训学习记录详细
export function getTmTrainRecord(id) {
  return request({
    url: '/train/TmTrainRecord/' + id,
    method: 'get'
  })
}


// 新增培训学习记录
export function addTmTrainRecord(data) {
  return request({
    url: '/train/TmTrainRecord',
    method: 'post',
    data: data
  })
}

// 修改培训学习记录
export function updateTmTrainRecord(data) {
  return request({
    url: '/train/TmTrainRecord/edit',
    method: 'post',
    data: data
  })
}

// 删除培训学习记录
export function delTmTrainRecord(id) {
  return request({
    url: '/train/TmTrainRecord/delete',
    method: 'post',
    data: id
  })
}

// 查询培训学习记录列表
export function listTmTrainRecordByPeopleId(query) {
  return request({
    url: '/train/TmTrainRecord/allListByPeopleId',
    method: 'get',
    params: query
  })
}

