import request from '@/utils/request'

// 查询考试管理列表
export function listExamination(query) {
  return request({
    url: '/train/examination/list',
    method: 'get',
    params: query
  })
}

// 查询考试管理详细
export function getExamination(id) {
  return request({
    url: '/train/examination/' + id,
    method: 'get'
  })
}

// 新增考试管理
export function addExamination(data) {
  return request({
    url: '/train/examination',
    method: 'post',
    data: data
  })
}

// 修改考试管理
export function updateExamination(data) {
  return request({
    url: '/train/examination/edit',
    method: 'post',
    data: data
  })
}

// 删除考试管理
export function delExamination(id) {
  return request({
    url: '/train/examination/delete/' + id,
    method: 'post'
  })
}

// 自动生成题库->题目数组列表
export function randomQuestionDirectoryList(data) {
  return request({
    url: '/train/examination/randomQuestionDirectoryList',
    method: 'post',
    data: data
  })
}

// 查询我的考试管理列表
export function mineListExamination(query) {
  return request({
    url: '/train/examination/mineList',
    method: 'get',
    params: query
  })
}

// 查询考试管理详细
export function startExamination(id, repairExamination) {
  return request({
    url: '/train/examination/start/' + id + '&' + repairExamination,
    method: 'get'
  })
}

// 我的考试》提交答案接口
export function submitAnswers(data) {
  return request({
    url: '/train/examination/submitAnswers',
    method: 'post',
    data: data
  })
}

// 查询阅卷管理列表
export function paperList(query) {
  return request({
    url: '/train/examination/paperList',
    method: 'get',
    params: query
  })
}

// 查询单个人答题题目详情
export function getPaperInfo(id) {
  return request({
    url: '/train/examination/paperInfo/' + id,
    method: 'get'
  })
}

// 阅卷
export function markPaper(data) {
  return request({
    url: '/train/examination/markPaper',
    method: 'post',
    data: data
  })
}

// 查询我的考试详情
export function minePaperInfo(id) {
  return request({
    url: '/train/examination/minePaperInfo/' + id,
    method: 'get'
  })
}

// 查询统计
export function pieChartListCount(query) {
  return request({
    url: '/train/examination/pieChartListCount',
    method: 'get',
    params: query
  })
}

// 查询统计列表
export function pieChartList(query) {
  return request({
    url: '/train/examination/pieChartList',
    method: 'get',
    params: query
  })
}