import request from '@/utils/request'

// 查询题库列表
export function listQuestionBank(query) {
  return request({
    url: '/train/questionBank/list',
    method: 'get',
    params: query
  })
}

// 查询题库详细
export function getQuestionBank(id) {
  return request({
    url: '/train/questionBank/' + id,
    method: 'get'
  })
}

// 新增题库
export function addQuestionBank(data) {
  return request({
    url: '/train/questionBank',
    method: 'post',
    data: data
  })
}

// 修改题库
export function updateQuestionBank(data) {
  return request({
    url: '/train/questionBank/edit',
    method: 'post',
    data: data
  })
}

// 删除题库
export function delQuestionBank(id) {
  return request({
    url: '/train/questionBank/delete/' + id,
    method: 'post'
  })
}
