import request from '@/utils/request'

// 查询题库目录列表
export function listQuestionDirectory(query) {
  return request({
    url: '/train/questionDirectory/list',
    method: 'get',
    params: query
  })
}

// 查询题库目录详细
export function getQuestionDirectory(id) {
  return request({
    url: '/train/questionDirectory/' + id,
    method: 'get'
  })
}

// 新增题库目录
export function addQuestionDirectory(data) {
  return request({
    url: '/train/questionDirectory',
    method: 'post',
    data: data
  })
}

// 修改题库目录
export function updateQuestionDirectory(data) {
  return request({
    url: '/train/questionDirectory/edit',
    method: 'post',
    data: data
  })
}

// 删除题库目录
export function delQuestionDirectory(id) {
  return request({
    url: '/train/questionDirectory/delete/' + id,
    method: 'post'
  })
}

// 查询题库目录列表
export function noPageList(query) {
  return request({
    url: '/train/questionDirectory/noPageList',
    method: 'get',
    params: query
  })
}

// 查询题库目录列表：包含选项内容数据
export function noPageOptionList(query) {
  return request({
    url: '/train/questionDirectory/noPageOptionList',
    method: 'get',
    params: query
  })
}