import request from '@/utils/request'

// 查询题库目录选项列表
export function listQuestionDirectoryOption(query) {
  return request({
    url: '/train/questionDirectoryOption/list',
    method: 'get',
    params: query
  })
}

// 查询题库目录选项详细
export function getQuestionDirectoryOption(id) {
  return request({
    url: '/train/questionDirectoryOption/' + id,
    method: 'get'
  })
}

// 新增题库目录选项
export function addQuestionDirectoryOption(data) {
  return request({
    url: '/train/questionDirectoryOption',
    method: 'post',
    data: data
  })
}

// 修改题库目录选项
export function updateQuestionDirectoryOption(data) {
  return request({
    url: '/train/questionDirectoryOption/edit',
    method: 'post',
    data: data
  })
}

// 删除题库目录选项
export function delQuestionDirectoryOption(id) {
  return request({
    url: '/train/questionDirectoryOption/delete/' + id,
    method: 'post'
  })
}
