import request from '@/utils/request'

// 查询问卷调查列表
export function listQuestionnaire(query) {
  return request({
    url: '/train/questionnaire/list',
    method: 'get',
    params: query
  })
}

// 查询问卷调查详细
export function getQuestionnaire(id) {
  return request({
    url: '/train/questionnaire/' + id,
    method: 'get'
  })
}

// 新增问卷调查
export function addQuestionnaire(data) {
  return request({
    url: '/train/questionnaire',
    method: 'post',
    data: data
  })
}

// 修改问卷调查
export function updateQuestionnaire(data) {
  return request({
    url: '/train/questionnaire/edit',
    method: 'post',
    data: data
  })
}

// 删除问卷调查
export function delQuestionnaire(id) {
  return request({
    url: '/train/questionnaire/delete/' + id,
    method: 'post',
    data: id
  })
}

// 查询我的问卷调查列表
export function mineList(query) {
  return request({
    url: '/train/questionnaire/mineList',
    method: 'get',
    params: query
  })
}

// 我的问卷》提交答案接口
export function submitAnswers(data) {
  return request({
    url: '/train/questionnaire/submitAnswers',
    method: 'post',
    data: data
  })
}
// 查询我的考试详情
export function minePaperInfo(id) {
  return request({
    url: '/train/questionnaire/minePaperInfo/' + id,
    method: 'get'
  })
}
// 查询问卷调查详细(统计)
export function getStatisticsQuestionnaire(id) {
  return request({
    url: '/train/questionnaire/statistics/' + id,
    method: 'get'
  })
}

// 修改问卷调查状态
export function updateRelease(data) {
  return request({
    url: '/train/questionnaire/updateRelease',
    method: 'post',
    data: data
  })
}


