import request from '@/utils/request'

// 查询我的问卷列表
export function listQuestionnaireMine(query) {
  return request({
    url: '/train/questionnaireMine/list',
    method: 'get',
    params: query
  })
}

// 查询我的问卷详细
export function getQuestionnaireMine(id) {
  return request({
    url: '/train/questionnaireMine/' + id,
    method: 'get'
  })
}

// 新增我的问卷
export function addQuestionnaireMine(data) {
  return request({
    url: '/train/questionnaireMine',
    method: 'post',
    data: data
  })
}

// 修改我的问卷
export function updateQuestionnaireMine(data) {
  return request({
    url: '/train/questionnaireMine/edit',
    method: 'post',
    data: data
  })
}

// 删除我的问卷
export function delQuestionnaireMine(id) {
  return request({
    url: '/train/questionnaireMine/delete/' + id,
    method: 'post',
    data: id
  })
}
