import request from '@/utils/request'

// 查询试题类型占比列表
export function listTopicRation(query) {
  return request({
    url: '/train/topicRation/list',
    method: 'get',
    params: query
  })
}

// 查询试题类型占比详细
export function getTopicRation(id) {
  return request({
    url: '/train/topicRation/' + id,
    method: 'get'
  })
}

// 新增试题类型占比
export function addTopicRation(data) {
  return request({
    url: '/train/topicRation',
    method: 'post',
    data: data
  })
}

// 修改试题类型占比
export function updateTopicRation(data) {
  return request({
    url: '/train/topicRation/edit',
    method: 'post',
    data: data
  })
}

// 删除试题类型占比
export function delTopicRation(id) {
  return request({
    url: '/train/topicRation/delete/' + id,
    method: 'post'
  })
}
