import request from '@/utils/request'

// 查询培训反馈记录列表
export function listTrainPlanFeedBack(query) {
  return request({
    url: '/train/trainPlanFeedBack/list',
    method: 'get',
    params: query
  })
}

// 查询培训反馈记录详细
export function getTrainPlanFeedBack(id) {
  return request({
    url: '/train/trainPlanFeedBack/' + id,
    method: 'get'
  })
}

// 新增培训反馈记录
export function addTrainPlanFeedBack(data) {
  return request({
    url: '/train/trainPlanFeedBack',
    method: 'post',
    data: data
  })
}

// 修改培训反馈记录
export function updateTrainPlanFeedBack(data) {
  return request({
    url: '/train/trainPlanFeedBack/edit',
    method: 'post',
    data: data
  })
}

// 删除培训反馈记录
export function delTrainPlanFeedBack(id) {
  return request({
    url: '/train/trainPlanFeedBack/delete/' + id,
    method: 'post'
  })
}
