import { ref, watch } from 'vue'
import { useDict } from '@/utils/dict'

const { att_status } = useDict('att_status')

watch(() => att_status, (arr) => {
  arr.value.forEach(item => {
    if (status.value[item.value].name) {
      status.value[item.value].name = item.label
    }
  })
}, { deep: true })

/**
 * 异常：迟到、早退、矿工；
  两个及一个以下状态均展示；
  存在两个以上状态，正常不展示；
  两个以上状态优先展示异常状态：
  存在3个异常状态，展示【异常】，
  存在3个及以上非异常状态，展示前两个；
  颜色分类：异常-请假-出差/正常-休息
 */
export const status = ref({
  1: {
    name: '正常',
    type: '正常',
    icon: 'normal',
    color: '#356CEC',
    bg: '#7CA3FF'
  },
  2: {
    name: '迟到',
    type: '异常',
    icon: 'abnormal',
    color: '#E94F12',
    bg: '#FFF9F6'
  },
  3: {
    name: '早退',
    type: '异常',
    icon: 'abnormal',
    color: '#E94F12',
    bg: '#FFF9F6'
  },
  4: {
    name: '矿工',
    type: '异常',
    icon: 'abnormal',
    color: '#E94F12',
    bg: '#FFF9F6'
  },
  5: {
    name: '出差',
    type: '出差',
    icon: 'evection',
    color: '#92B913',
    bg: '#F9FFF6'
  },
  6: {
    name: '休息',
    type: '休息',
    icon: 'rest',
    color: '#2E2E2E',
    bg: '#F8F8F8'
  },
  7: {
    name: '签卡',
    type: '正常',
    icon: 'normal',
    color: '#356CEC',
    bg: '#7CA3FF'
  },
  8: {
    name: '调休',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#F8F8F8'
  },
  9: {
    name: '年假',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  10: {
    name: '事假',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  11: {
    name: '病假',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  12: {
    name: '丧假',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  13: {
    name: '婚嫁',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  14: {
    name: '产假',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  15: {
    name: '陪产假',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  16: {
    name: '工伤假',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  17: {
    name: '哺乳假',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  // 18: {
  //   name: '法定假',
  //   type: '国假',
  //   icon: 'statutory',
  //   color: '#792ba6',
  //   bg: '#F8F8F8'
  // },
  18: {
    name: '产检假',
    type: '请假',
    icon: 'leave',
    color: '#FFB67C',
    bg: '#FFF9EE'
  },
  19: {
    name: '外出',
    type: '外出',
    icon: 'outside',
    color: '#92B913',
    bg: '#F9FFF6'
  },
  20: {
    name: '异常外勤',
    type: '异常',
    icon: 'abnormal',
    color: '#E94F12',
    bg: '#FFF9F6'
  },
  21: {
    name: '出差外勤',
    type: '出差',
    icon: 'outside',
    color: '#92B913',
    bg: '#F9FFF6'
  }
  // 'weekend': {
  //   name: '周日',
  //   type: '周末',
  //   icon: 'rest',
  //   color: '#00b342',
  //   bg: '#F8F8F8'
  // }
})

export const themes = ref({
  normal: {
    name: '正常',
    icon: 'normal',
    color: '#356CEC',
    bg: '#F8FAFF',
    range: ['1', '7']
  },
  abnormal: {
    name: '异常',
    icon: 'abnormal',
    color: '#E94F12',
    bg: '#FFF9F6',
    range: ['2', '3', '4', '20']
  },
  rest: {
    name: '休息',
    icon: 'rest',
    color: '#2E2E2E',
    bg: '#F8F8F8',
    range: ['6', '18']
  },
  evection: {
    name: '出差',
    icon: 'evection',
    color: '#92B913',
    bg: '#F9FFF6',
    range: ['5', '21']
  },
  outside: {
    name: '外出',
    icon: 'evection',
    color: '#92B913',
    bg: '#F9FFF6',
    range: ['19']
  },
  leave: {
    name: '请假',
    icon: 'rest',
    color: '#FFB67C',
    bg: '#FFF9EE',
    range: ['8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18']
  }
  // statutory: {
  //   name: '法定假',
  //   icon: 'statutory',
  //   color: '#792ba6',
  //   bg: '#F8F8F8'
  // },
  // weekend: {
  //   name: '周末',
  //   icon: 'weekend',
  //   color: '#00b342',
  //   bg: '#F8F8F8'
  // }
})
