import type { FormRules } from 'element-plus'

// 表单组件类型
export type FieldType =
  'selection' |
  'index' |
  'title' |
  'autocomplete' |
  'input' |
  'number' |
  'radio' |
  'checkbox' |
  'checkbox-group' |
  'year' |
  'month' |
  'date' |
  'datetime' |
  'week' |
  'datetimerange' |
  'daterange' |
  'time' |
  'select' |
  'select-v2' |
  'treeselect' |
  'treeselect-v2' |
  'cascader' |
  'switch'

// 字段值类型
export type FormItemTypes = string | number | null | [] | {}

// 字段表单
export interface IForm<T = FormItemTypes> {
  [propName: string]: T
}

// 动态表单
export interface IForms {
  id: string,
  [propName: string]: FormItemTypes
}

// th|td单元格align 水平对齐
export type Align = 'center' | 'left' | 'right' | 'justify' | 'char' | undefined

// 选项类数据类型
export interface Options {
  label?: string
  value?: string | number
  [propName: string]: any
}

// 动态表单，底部按钮
export type TActions = 'add' | 'delete' | 'dropsort'
export interface IActions {
  add?: boolean
  delete?: boolean
  dropsort?: boolean
}
export type Actions = boolean | TActions[]

// 字段标题单元格
export interface Label {
  text: string
  rowspan?: number
  colspan?: number
  align?: Align
  indent?: number | string // 缩进
  style?: any
}

// 字段表单组件单元格
export interface Value {
  rowspan?: number
  colspan?: number
  align?: Align
}

// 表单组件事件回调函数集合
export interface On {
  change?: any
  select?: any
  blur?: any
  focus?: any
  input?: any
  clear?: any
  calendarChange?: any
  panelChange?: any
  visibleChange?: any
  removeTag?: any
  expandChange?: any
}

// 列属性
export interface Columns {
  type?: FieldType
  width?: string | number
  field?: string
  name?: string
  required?: boolean
  rules?: FormRules
  options?: Options[]
  align?: Align
  headerAlign?: Align
  attrs?: any,
  rows?: any
}

// 字段表单行数据类型
export interface DataSource extends Columns {
  label?: Label,
  value?: Value
  hide?: boolean
  on?: On
}