import nanoid from '@/utils/nanoid'

export const formTypes = {
  'autocomplete': '',
  'input': '',
  'number': null,
  'radio': null,
  'checkbox': null,
  'checkbox-group': [],
  'year': '',
  'month': '',
  'date': '',
  'datetime': '',
  'week': '',
  'datetimerange': [],
  'daterange': [],
  'time': '',
  'select': null,
  'treeselect': null,
  'cascader': null,
  'switch': null
}


/**
 * 构造基础表单结构数据
 * @author sunidea
 * @param {Array<string>} types 字段字符串集合 id为nanoid
 */
export default function (columns) {
  const form = {
    id: nanoid()
  }
  for (const i in columns) {
    const column = columns[i]
    if (formTypes[column.type] === undefined) continue
    form[column.field] = JSON.parse(JSON.stringify(formTypes[column.type]))
  }
  return form
}