import { h } from 'vue'
import type { VNode, RendererNode, RendererElement } from 'vue'
import { ElPopover, ElTooltip } from 'element-plus'
import styles from './index.module.scss'

// 渲染高亮 正则表达式
export function RegExpescape(str: string) {
  str = str ?? ''
  return str.replace(/([.*+?^${}()|[\]/\\])/g, '\\$1')
}

/**
 * 渲染高亮
 * @param prop.value 搜索关键字
 * @param prop.content 模板内容
 * @param prop.tag 标签 可选
 * @returns {HTMLElement}
 */
export default function HightLight(prop: { value: string; content?: string; tag?: string; align?: string; ellipsis?: boolean }): VNode<RendererNode, RendererElement, {
  [key: string]: any;
}> | string {
  let { value, ellipsis, content, tag = 'span', align } = prop
  ellipsis = ellipsis ?? true
  if (!content) return ''
  const reg = new RegExp(RegExpescape(value))
  // console.log(reg)
  // const contents = content.replace()
  const contents = value === content ? [''] : content.split(reg)
  const items = value && contents.length ? contents.map((item, index) => {
    if (!item) {
      return h('span', { style: 'color:#ff0000' }, value)
    }
    if (contents[index + 1]) {
      return [
        h('span', item),
        h('span', { style: 'color:#ff0000' }, value)
      ]
    }
    return h('span', item)
  }) : h('span', {}, content)
  return h(tag, {
    class: [
      ellipsis ? styles.ellipsis : ''
    ],
    style: {
      textAlign: align
    }
  }, items)
}

/**
 * table - tooltip
 * @param prop.value 搜索关键字
 * @param prop.content 模板内容
 * @returns {HTMLElement}
 */
export function HighLightTooltip(prop: { value?: any; content?: any; tag?: any; align?: string; }): VNode<RendererNode, RendererElement, {
  [key: string]: any;
}> | string {
  const { value, content, align } = prop
  if (!content) return ''
  return h(
    ElTooltip,
    {
      placement: 'top',
      effect: 'light',
      trigger: 'hover'
    },
    {
      content: () => h(
        HightLight,
        {
          content,
          value,
          tag: 'div',
          ellipsis: false,
          style: 'max-width:200px;',
          align
        }
      ),
      default: () => h(
        'div',
        null,
        h(
          HightLight,
          {
            content,
            value,
            tag: 'div',
            style: 'width:100%;',
            align
          }
        )
      )
    }
  )
}

