/**
 * 重构tree数据(init)
 * @param {Array} data treeData
 * @returns {Array}
 */
export const generateTreeData = (data) => {
  return data.map(item => ({
    ...item,
    targetId: item.id,
    // targetId: item.type === 'user' ? item.staffCode : item.id,
    name: item.label,
    'node-key': item.id,
    type: item.type === 'user' ? 1 : item.type === 'office' ? 3 : 2,
    children: Array.isArray(item.children) && item.children.length ? generateTreeData(item.children) : null
  }))
}

/**
 * 重构已选数据(sort by treeData)
 * @param {Array} data treeData
 * @param {Array<String>} checkedKeys 已选key
 * @returns {Array<Object>} 已选列表数据
 */
export const generateCheckedData = <T extends {id: string; children?: T[]}>(data: T[], checkedKeys: string[]): T[] => {
  let arr: T[] = []
  for (const item of data) {
    if (checkedKeys.includes(item.id)) arr = [...arr, item]
    if (Array.isArray(item.children) && item.children.length) {
      arr = [...arr, ...generateCheckedData(item.children, checkedKeys)]
    }
  }
  return arr
}

/**
 * 生成已选列表(sort by clicked)
 * @param {Array<Object>} data treeData
 * @param {Array<String>} checkedKeys
 * @returns {Array<Object>}
 */
export const generateCheckedDataSort = (data, checkedKeys) => {
  return checkedKeys.map(key => getEqualKeyData(data, key))
}
/**
 * 查找key所在项
 * @param {Array<Object>} data treeData
 * @param {String} key target key
 * @returns {Object} target object
 */
export const getEqualKeyData = (data, key) => {
  for (const item of data) {
    if (item.key === key) return item
    else if (Array.isArray(item.children) && item.children.length) {
      const result = getEqualKeyData(item.children, key)
      if (result) return result
    }
  }
}

/**
 * 合并树
 * @param {Array} source source treeData
 * @param {Array} target target treeData
 * @returns {Array} target object
 */
export const mergeTreeData = (source, target) => {
  const arr = JSON.parse(JSON.stringify(source))
  for (const i in target) {
    if (!arr[i]) {
      arr[i] = target[i]
    } else {
      for (const j in target[i]) {
        if (Array.isArray(target[i].children) && target[i].children.length) {
          if (!arr[i].children || (Array.isArray(target[i].children) && !target[i].children.length)) {
            arr[i].children = target[i].children
          } else {
            arr[i].children = [...arr.children, ...mergeTreeData(arr[i].children, target[i].children)]
          }
        } else {
          arr[i][j] = target[i][j]
        }
      }
    }
  }
  return arr
}
