export default {
  mounted(el, binding, vNode) {
    let expression = binding.value
    let handler = expression.name
    let args = expression.args
    let startX = 0
    let startY = 0
    let now = new Date().getTime()
    el.addEventListener('touchstart', (e) => {
      e.preventDefault()
      e.stopPropagation()
      now = new Date().getTime()
      startX = e.changedTouches[0].clientX
      startY = e.changedTouches[0].clientY
    }, false)
    el.addEventListener('touchend', (e) => {
      let disX = Math.abs(e.changedTouches[0].clientX - startX)
      let disY = Math.abs(e.changedTouches[0].clientY - startY)
      if (disX === 0 && disY === 0 && new Date().getTime() - now < 300) {
        if (typeof expression === 'function') {
          expression(e)
        } else {
          if (args) {
            handler(args)
          } else {
            handler()
          }
        }
      }
      // now = new Date().getTime()
    }, false)
  }
}