import useAppStore from '@/store/modules/app'
import useUserStore from '@/store/modules/user'

let timer: ReturnType<typeof setTimeout>

// 轮询
export default function polling() {
  const appStore = useAppStore()
  const userStore = useUserStore()
  const { updateNotice } = appStore
  clearTimeout(timer)
  if (userStore.token) {
    updateNotice().finally(() => {
      timer = setTimeout(() => {
        polling()
      }, 300000)
    })
  } else {
    timer = setTimeout(() => {
      polling()
    }, 300000)
  }
}