import {
  // createNode,
  // getSnowflake,
  // uuid,
  // addNodeCreateLine,
  // moveNodeAndLine,
  // getLastCurrentNextNodeById,
  pointToGrid, // 转换网格坐标
  // pointInSegments, // 得到目标相邻的2个点
  checkActives,
  onDropNodes,
  resetDropNodesPolyline,
  // getMovingPoint, // 计算画布中坐标
  updateNodeConfigSnapshots
} from '../utils/index'
import type { INodes, IPaths, IState } from '../utils/INodes'
// import { varibles as getVaribles } from './SvgWrap'

import * as variables from './variables'

const {
  nodeConfig,
  dragNodes,
  dragNode,
  hoverNode,
  actives,
  canMoveNodes,
  x,
  y,
  oldX,
  oldY,
  scale,
  oldScale,
  pageX,
  pageY,
  state
} = variables

let lastTime = new Date().getTime()

// 点击节点
export function onClickNodes(item) {
  // 显示菜单
  actives.value.splice(0, actives.value.length, item.id)
}

// 拖拽节点 - 开始
function EventStart(e, node) {
  e.preventDefault()
  e.stopPropagation()
  if (state.value.draggingPoint) return
  if (e.button !== 0 && !e.touches || e.touches && e.touches.length > 1) return
  lastTime = new Date().getTime()
  dragNode.value = node
  pageX.value = e.pageX ?? e.changedTouches[0].pageX
  pageY.value = e.pageY ?? e.changedTouches[0].pageY
  oldX.value = x.value
  oldY.value = y.value
  oldScale.value = scale.value
  document.addEventListener('touchmove', EventMove, false)
  document.addEventListener('touchend', EventEnd, false)
  document.addEventListener('mousemove', EventMove, false)
  document.addEventListener('mouseup', EventEnd, false)
}
function setMovedXY(e) {
  const deltaX = pointToGrid(((e.pageX ?? e.changedTouches[0].pageX) - pageX.value - (x.value - oldX.value)) / scale.value)
  const deltaY = pointToGrid(((e.pageY ?? e.changedTouches[0].pageY) - pageY.value - (y.value - oldY.value)) / scale.value)
  dragNodes.value!.forEach((item, index) => {
    item.nodePath.position.x = deltaX + item.nodePath.position.lastX
    item.nodePath.position.y = deltaY + item.nodePath.position.lastY
  })
}
// 拖拽节点 - 中
function EventMove(e) {
  if (!e.touches) e.preventDefault()
  e.stopPropagation()
  // 隔离点击事件
  if (new Date().getTime() - lastTime < 300 && (e.pageX ?? e.changedTouches[0].pageX) === pageX.value && (e.pageY ?? e.changedTouches[0].pageY) === pageY.value) {
    return
  }
  if (!canMoveNodes.value) {
    canMoveNodes.value = true
    // 首次缓存节点数据
    if (actives.value.length) {
      if (!actives.value.includes(dragNode!.value!.id)) {
        actives.value.splice(0, actives.value.length, dragNode!.value!.id)
      }
      dragNodes.value = JSON.parse(JSON.stringify(nodeConfig.value.filter(item => actives.value.includes(item.id))))
    }
    // 只有一个节点被选中
    if (!dragNodes.value?.length) {
      dragNodes.value = [JSON.parse(JSON.stringify(dragNode.value))]
    }
    if (!actives.value.length) {
      actives.value.splice(0, actives.value.length, ...dragNodes.value.map(node => node.id))
    }
    for (let item of dragNodes.value) {
      // 添加残影在nodeConfig在第一个位置
      item.nodePath.position.lastX = item.nodePath.position.x
      item.nodePath.position.lastY = item.nodePath.position.y
    }
  }

  setMovedXY(e)
}
// 拖拽节点 - 结束
function EventEnd(e) {
  if (!e.touches) e.preventDefault()
  canMoveNodes.value = false
  document.removeEventListener('touchmove', EventMove, false)
  document.removeEventListener('touchend', EventEnd, false)
  document.removeEventListener('mousemove', EventMove, false)
  document.removeEventListener('mouseup', EventEnd, false)

  // 判断是点击事件
  if (new Date().getTime() - lastTime < 300 && (e.pageX ?? e.changedTouches[0].pageX) === pageX.value && (e.pageY ?? e.changedTouches[0].pageY) === pageY.value) {
    if (e.shiftKey) {
      // 按住SHIFT单击多选
      checkActives(actives.value, dragNode.value!.id)
      return
    }
    // 单选时，切换选中状态
    if (actives.value.includes(dragNode.value!.id) && actives.value.length === 1) {
      actives.value.splice(0, actives.value.length)
    } else {
      actives.value.splice(0, actives.value.length, dragNode.value!.id)
    }
    // 单击结束后，清空拖拽中的节点
    dragNodes.value?.splice(0, dragNodes.value?.length)
    return
  }
  // 拖拽结束后，清空已选id
  if (actives.value.length === 1) {
    actives.value.splice(0, actives.value.length)
  }

  onDropNodes(nodeConfig.value, dragNodes.value)

  resetDropNodesPolyline(nodeConfig.value, dragNodes.value)

  // 删除虚拟拖拽节点
  dragNodes.value!.splice(0, dragNodes.value?.length)
  updateNodeConfigSnapshots()
}

export function onMouseDownNodes(e, node) {
  EventStart(e, node)
}

export function onTouchStartNodes(e, node) {
  EventStart(e, node)
}

export function onMouseOverNodes(e, item) {
  hoverNode.value = item
  state.value.isHoverNode = true
}
export function onMouseLeaveNodes(e, item) {
  // console.log('onMouseLeaveNodes', item, index)
  hoverNode.value = null
  state.value.isHoverNode = false
}