import {
  // dist2d,
  // addNodeCreateLine,
  pointToGrid, // 转换网格坐标
  pointInSegments, // 得到目标相邻的2个点
  filterPointInSegments,
  // pointToFootDist,
  // intersects,
  // lineIntersect,
  inRect,
  getNearestIntersectPoint, // 获取线与线相交最近的点，转成网格坐标
  getMovingPoint, // 计算画布中坐标
  updateNodeConfigSnapshots,
  createPath
} from '../utils/index'
import nodesDefault from '../utils/nodesDefault'
import type { INodes, IPaths, IState } from '../utils/INodes'
import * as variables from './variables'

const {
  svgWrap,
  nodeConfig,
  dragNodes,
  hoverNode,
  dragPath,
  dragPoint,
  actives,
  x,
  y,
  oldX,
  oldY,
  scale,
  oldScale,
  pageX,
  pageY,
  // startX,
  // startY,
  // xSelection,
  // ySelection,
  state,
  hoverPolyine,
  floating,
  diffX,
  diffY,
  offsetX,
  offsetY,
  currentNode,
  currentPath,
  canMovePolyline,
  segment,
  isStartPoint,
  isEndPoint
} = variables


// const nodeConfig = inject<INodes[]>('nodeConfig')
// const dragNodes = inject<INodes[]>('dragNodes') // 拖拽中的节点
// const hoverNode = inject<INodes>('hoverNode') // 鼠标经过的的节点对象
// const dragPath = inject<IPaths>('dragPath') // 拖拽中的节点
// const dragPoint = inject<Ref<number[]>>('dragPoint')!

let oldDate = new Date().getTime()

// export const floating = ref([0, 0])
// export const diffX = ref(0) // 原点坐标x
// export const diffY = ref(0) // 原点坐标y
// export const offsetX = ref(0)
// export const offsetY = ref(0)
// export const currentNode = ref<INodes | null>(null) // 当前拖拽点所属node
// export const currentPath = ref<IPaths | null>(null) // 当前path
// export const canMovePolyline = ref(false) // 线可拖动状态
// export const segment = ref<string[] | null>(null) // ['123,321', '321,123']包含2个点的线段
// export const isStartPoint = ref(false)
// export const isEndPoint = ref(false)


// 鼠标经过
export function onMouseOver(e, path) {
  if (canMovePolyline.value) {
    e.preventDefault()
    return
  }
  hoverPolyine.value = path.id
  const newX = (e.offsetX - x.value) / scale.value
  const newY = (e.offsetY - y.value) / scale.value
  const segmentResult = pointInSegments([newX, newY], path.points)
  if (segmentResult.index === null) return
  floating.value = [
    Math.round(segmentResult.point[0] * 2) / 2,
    Math.round(segmentResult.point[1] * 2) / 2
  ]
}
// 鼠标移开
export function onMouseleave(e, item) {
  hoverPolyine.value = ''
}
// 点击线
export function onClickPolyline(e) {
  if (actives.value.includes(dragPath.value?.id ?? '') && actives.value.length === 1) {
    actives.value.splice(0, actives.value.length)
  } else {
    actives.value.splice(0, actives.value.length, dragPath.value?.id ?? '')
  }
  dragPath.value = null
  dragPoint.value.splice(0, 2)
}
/**
 * 计算首/尾点的坐标
 * 当前拖拽中的点是 首点后或尾点前
 * @param {Array} point 当前鼠标坐标
 */
export function getNearFirstOrLast(point) {
  console.log('计算首尾')
  // 不是首尾点
  const indexPoint = dragPath.value?.points.findIndex(item => item === dragPoint.value)
  if (indexPoint === 1) {
    // 首点后
    const pointFirst = dragPath.value?.points[0] // 首点
    const originFrom = [currentPath.value?.from.originX, currentPath.value?.from.originY]
    const intersectPoint = getNearestIntersectPoint(point, originFrom, currentNode.value)
    pointFirst?.splice(0, 2, ...intersectPoint)
  }
  if (indexPoint === dragPath.value?.points.length! - 2) {
    // 尾点前
    const pointLast = dragPath.value?.points.slice(-1)[0] // 尾点
    const toNode = nodeConfig.value?.find(node => node.id === dragPath.value?.to.id)
    const originTo = [currentPath.value?.to.originX, currentPath.value?.to.originY]
    const intersectPoint = getNearestIntersectPoint(point, originTo, toNode)
    pointLast?.splice(0, 2, ...intersectPoint)
  }
}
// point拖拽 - 开始
function EventStartPoint(e, node, path, point) {
  e.preventDefault()
  e.stopPropagation()
  currentNode.value = node
  currentPath.value = path
  const indexPoint = path.points.findIndex(item => item === point)
  dragPath.value = JSON.parse(JSON.stringify(path))
  dragPoint.value = dragPath.value?.points[indexPoint]!
  oldDate = new Date().getTime()
  canMovePolyline.value = true
  pageX.value = e.pageX ?? e.changedTouches[0].pageX
  pageY.value = e.pageY ?? e.changedTouches[0].pageY
  oldX.value = x.value
  oldY.value = y.value
  oldScale.value = scale.value
  diffX.value = pointToGrid(point[0])
  diffY.value = pointToGrid(point[1])

  // 判断是否是开始或结束节点
  isStartPoint.value = isEndPoint.value = false
  if (point === path.points[0]) {
    isStartPoint.value = true
  } else if (point === path.points[path.points.length - 1]) {
    isEndPoint.value = true
  } else {
    // 拖拽的不是开始也不是结束点
    dragPath.value!.type = 1
  }
  console.log('touchstart')
  document.addEventListener('mousemove', EventMovePoint, false)
  document.addEventListener('mouseup', EventEndPoint, false)
  document.addEventListener('touchmove', EventMovePoint, false)
  document.addEventListener('touchend', EventEndPoint, false)
}
export function onMouseDownPoint(e, node, path, point) {
  EventStartPoint(e, node, path, point)
}
export function onTouchStartPoint(e, node, path, point) {
  EventStartPoint(e, node, path, point)
}
// 更新点坐标
export function setMovedXYLine(e) {
  let point = getMovingPoint({
    pageX: e.pageX ?? e.changedTouches[0].pageX,
    pageY: e.pageY ?? e.changedTouches[0].pageY,
    oldPageX: pageX.value,
    oldPageY: pageY.value,
    x: x.value,
    y: y.value,
    oldX: oldX.value,
    oldY: oldY.value,
    scale: scale.value,
    oldScale: oldScale.value,
    diffX: diffX.value,
    diffY: diffY.value
  })
  // 开始点和结束点
  if (isStartPoint.value || isEndPoint.value) {
    if (!state.value.isHoverNode || !inRect(point, hoverNode.value)) {
      // 鼠标未经过节点
      dragPath.value!.type = 2
      if (isStartPoint.value) {
        // 起始点
        const toNode = nodeConfig.value.find(node => node.id === dragPath.value?.to.id)
        const nearPoint = getNearestIntersectPoint([dragPath.value?.to.originX, dragPath.value?.to.originY], point, toNode)
        dragPath.value?.points.splice(0, dragPath.value.points.length, ...[point, nearPoint])
        dragPoint.value.splice(0, 2, ...dragPath.value!.points[0])
        dragPath.value!.from.id = ''
      } else if (isEndPoint.value) {
        // 结束点
        const nearPoint = getNearestIntersectPoint([dragPath.value?.from.originX, dragPath.value?.from.originY], point, currentNode.value)
        dragPath.value?.points.splice(0, dragPath.value?.points.length, ...[nearPoint, point])
        dragPoint.value.splice(0, 2, ...dragPath.value!.points.slice(-1)[0])
        dragPath.value!.to.id = ''
      }
    } else {
      // 鼠标经过节点
      dragPath.value?.points.splice(0, dragPath.value.points.length, ...JSON.parse(JSON.stringify(currentPath.value?.points)))
      const toNode = nodeConfig.value.find(node => node.id === currentPath.value?.to.id)
      if (isStartPoint.value && hoverNode.value) {
        // 拖拽首点
        console.log('鼠标经过节点', hoverNode.value.nodePath.from, currentPath.value?.to.id, nodesDefault, currentNode.value?.nodeType, hoverNode.value.nodeType)
        if (hoverNode.value === currentNode.value && inRect(point, hoverNode.value)) {
          // 经过起始点
          // 当前节点1
          dragPath.value!.type = 1
          dragPath.value!.from.id = hoverNode.value.id
          dragPath.value!.from.originX = point[0]
          dragPath.value!.from.originY = point[1]
          if (dragPath.value!.points.length < 3) {
            const toNewNode = nodeConfig.value.find(node => node.id === dragPath.value?.to.id)
            const path = createPath(hoverNode.value, toNewNode, point, [dragPath.value?.to.originX, dragPath.value?.to.originY])
            dragPath.value?.points.splice(0, dragPath.value.points.length, ...path.points)
            filterPointInSegments(dragPath.value?.points)
          } else {
            const { 0: x1, 1: y1 } = dragPath.value!.points[0]
            const { 0: x2, 1: y2 } = dragPath.value!.points[1]
            let nextPoint = dragPath.value!.points[1]
            if (x1 === x2) {
              nextPoint.splice(0, 1, point[0])
            } else if (y1 === y2) {
              nextPoint.splice(1, 1, point[1])
            }
            // 首点与
            const intersectPoint = getNearestIntersectPoint(point, nextPoint, hoverNode.value)
            dragPath.value!.points.splice(0, 1, pointToGrid(intersectPoint))
          }
        } else if (
          // 经过节点，检测重复连线、反向连接、权限校验、起始节点
          hoverNode.value === toNode ||
          hoverNode.value.nodePath.to.some(nodeId => nodeId === currentPath.value?.to.id) ||
          hoverNode.value.nodePath.from.some(nodeId => nodeId === currentPath.value?.to.id) ||
          !nodesDefault[hoverNode.value.nodeType].allow.includes(currentNode.value?.nodeType)
        ) {
          dragPath.value!.from.id = ''
          console.log('经过节点，已有重复连线')
          dragPath.value!.type = 2
          const intersectPoint = getNearestIntersectPoint(point, [dragPath.value!.to.originX, dragPath.value!.to.originY], toNode)
          dragPath.value!.points.splice(0, dragPath.value!.points.length, ...[point, intersectPoint])
        } else {
          // 经过有效节点
          dragPath.value!.type = 1
          dragPath.value!.from.id = hoverNode.value.id
          dragPath.value!.from.originX = point[0]
          dragPath.value!.from.originY = point[1]
          const toNewNode = nodeConfig.value.find(node => node.id === dragPath.value?.to.id)
          const path = createPath(hoverNode.value, toNewNode, point, [dragPath.value?.to.originX, dragPath.value?.to.originY])
          dragPath.value?.points.splice(0, dragPath.value.points.length, ...path.points)
        }
      } else {
        // 拖拽尾点
        if (hoverNode.value === toNode && inRect(point, hoverNode.value)) {
          // 经过结束节点
          dragPath.value!.to.id = hoverNode.value.id
          // 当前节点
          dragPath.value!.type = 1
          dragPath.value!.to.originX = point[0]
          dragPath.value!.to.originY = point[1]
          if (dragPath.value!.points.length < 3) {
            const fromNewNode = nodeConfig.value.find(node => node.id === dragPath.value!.from.id)
            const path = createPath(hoverNode.value, fromNewNode, point, [dragPath.value!.from.originX, dragPath.value!.from.originY])
            dragPath.value!.points.splice(0, dragPath.value!.points.length, ...path.points)
            filterPointInSegments(dragPath.value!.points)
          } else {
            const { 0: x1, 1: y1 } = dragPath.value!.points.slice(-1)[0]
            const { 0: x2, 1: y2 } = dragPath.value!.points.slice(-2)[0]
            let prePoint = dragPath.value!.points.slice(-2)[0]
            if (x1 === x2) {
              prePoint.splice(0, 1, point[0])
            } else if (y1 === y2) {
              prePoint.splice(1, 1, point[1])
            }
            // 首点与
            const intersectPoint = getNearestIntersectPoint(point, prePoint, hoverNode.value)
            console.log(point, prePoint, intersectPoint)
            dragPath.value!.points.splice(-1, 1, pointToGrid(intersectPoint))
          }
        } else if (
          // 经过节点，检测重复连线、反向连接、权限校验、结束节点
          hoverNode.value === currentNode.value ||
          hoverNode.value?.nodePath.from.some(nodeId => nodeId === currentPath.value!.from.id) ||
          hoverNode.value?.nodePath.to.some(nodeId => nodeId === currentPath.value!.from.id) ||
          !nodesDefault[currentNode.value!.nodeType].allow.includes(hoverNode.value?.nodeType)
        ) {
          dragPath.value!.to.id = ''
          dragPath.value!.type = 2
          const intersectPoint = getNearestIntersectPoint(point, [dragPath.value!.from.originX, dragPath.value!.from.originY], currentNode.value)
          dragPath.value!.points.splice(0, dragPath.value!.points.length, ...[point, intersectPoint])
        } else {
          // 经过有效节点
          dragPath.value!.type = 1
          dragPath.value!.to.id = hoverNode.value!.id
          dragPath.value!.to.originX = point[0]
          dragPath.value!.to.originY = point[1]
          const path = createPath(currentNode.value!, hoverNode.value!, [dragPath.value!.from.originX, dragPath.value!.from.originY], point)
          dragPath.value!.points.splice(0, dragPath.value!.points.length, ...path.points)
        }
      }
    }
  } else {
    // 计算首/尾点的坐标
    getNearFirstOrLast(point)
  }
  dragPoint.value.splice(0, 2, ...point)
}
// point拖拽 - 中
export function EventMovePoint(e) {
  console.log('move')
  console.log(e)
  if (!e.touches) e.preventDefault()
  e.stopPropagation()
  // 隔离点击事件
  if (new Date().getTime() - oldDate < 300 && (e.pageX ?? e.changedTouches[0].pageX) === pageX.value && (e.pageY ?? e.changedTouches[0].pageY) === pageY.value) {
    return
  }
  if (!canMovePolyline.value) return
  if (!state.value.draggingPoint) {
    state.value.draggingPoint = true
  }
  setMovedXYLine(e)
}
// 计算连线首尾点经过的节点的坐标
export function setMovedXYInNode(e) {
  // 如果是起始点，则传下一点，如果是结束点，反之
  const nearPoint = isStartPoint.value ? dragPath.value!.points[1] : dragPath.value!.points[dragPath.value!.points.length - 2]
  const point = getMovingPoint({
    pageX: (e.pageX ?? e.changedTouches[0].pageX),
    pageY: (e.pageY ?? e.changedTouches[0].pageY),
    oldPageX: pageX.value,
    oldPageY: pageY.value,
    x: x.value,
    y: y.value,
    oldX: oldX.value,
    oldY: oldY.value,
    scale: scale.value,
    oldScale: oldScale.value,
    diffX: diffX.value,
    diffY: diffY.value
  })
  // 取到线与节点的最近相交点
  const intersectPoint = getNearestIntersectPoint(point, nearPoint, hoverNode.value)
  dragPoint.value.splice(0, 2, ...pointToGrid(intersectPoint))
}
// point拖拽 - 结束
export function EventEndPoint(e) {
  canMovePolyline.value = false
  state.value.draggingPoint = false
  e.preventDefault()
  document.removeEventListener('touchmove', EventMovePoint)
  document.removeEventListener('touchend', EventEndPoint)
  document.removeEventListener('mousemove', EventMovePoint)
  document.removeEventListener('mouseup', EventEndPoint)
  if (new Date().getTime() - oldDate <= 300 && pageX.value === (e.pageX ?? e.changedTouches[0].pageX) && pageY.value === (e.pageY ?? e.changedTouches[0].pageY)) {
    onClickPolyline(e)
    return
  }
  if (dragPath.value!.type === 1) {
    // 是否首尾点
    if (isStartPoint.value || isEndPoint.value) {
      // 鼠标移上去如果在节点上设置点
      if (state.value.isHoverNode && inRect(dragPoint.value, hoverNode.value)) {
        setMovedXYInNode(e)
        setMovedNodeCodeId()
        // Object.assign(currentPath.value, JSON.parse(JSON.stringify(dragPath.value)))
      } else {
        // dragPoint.value.splice(0, 2)
        dragPoint.value.splice(0, 2, ...[diffX.value, diffY.value])
      }
    } else {
      // 不是开始节点，删除两点共线中间所有的点
      filterPointInSegments(dragPath.value!.points)
      Object.assign(currentPath.value!, JSON.parse(JSON.stringify(dragPath.value)))
    }
    updateNodeConfigSnapshots()
  }
  dragPath.value = null
  dragPoint.value.splice(0, 2)
}
// 拖拽首尾点结束后，设置节点id和code
export function setMovedNodeCodeId() {
  const toNode = nodeConfig.value.find(node => node.id === currentPath.value!.to.id)!
  if (!hoverNode.value) return
  if (isStartPoint.value) {
    // 处理code
    currentNode.value!.outputNodeCode = currentNode.value!.outputNodeCode.filter(code => code !== toNode.nodeCode)
    hoverNode.value.outputNodeCode.push(toNode.nodeCode)
    const toNodeCodeIndex = toNode.inputNodeCode.indexOf(currentNode.value!.nodeCode)
    toNode.inputNodeCode.splice(toNodeCodeIndex, 1, hoverNode.value.nodeCode)
    // 处理id
    currentNode.value!.nodePath.to = currentNode.value!.nodePath.to.filter(id => id !== toNode.id)
    hoverNode.value.nodePath.to.push(toNode.id)
    const toNodeIdIndex = toNode.nodePath.from.indexOf(currentNode.value!.id)
    toNode.nodePath.from.splice(toNodeIdIndex, 1, hoverNode.value.id)
    // 处理paths
    currentNode.value!.nodePath.paths = currentNode.value!.nodePath.paths.filter(path => path !== currentPath.value)
    hoverNode.value.nodePath.paths.push(JSON.parse(JSON.stringify(dragPath.value)))
  } else {
    // 处理code
    toNode.inputNodeCode = toNode.inputNodeCode.filter(code => code !== currentNode.value!.nodeCode)
    hoverNode.value.inputNodeCode.push(currentNode.value!.nodeCode)
    const fromNodeCodeIndex = currentNode.value!.inputNodeCode.indexOf(toNode.nodeCode)
    currentNode.value!.outputNodeCode.splice(fromNodeCodeIndex, 1, hoverNode.value.nodeCode)
    // 处理id
    toNode.nodePath.from = toNode.nodePath.from.filter(id => id !== currentNode.value!.id)
    hoverNode.value.nodePath.from.push(currentNode.value!.id)
    const fromNodeIdIndex = currentNode.value!.nodePath.from.indexOf(toNode.id)
    currentNode.value!.nodePath.to.splice(fromNodeIdIndex, 1, hoverNode.value.id)
    // 处理paths
    Object.assign(currentPath.value!, JSON.parse(JSON.stringify(dragPath.value)))
  }
}
// 新增点
export function onMousedown(e, node, path) {
  EventStart(e, node, path)
}
// 新增点
export function onTouchStart(e, node, path) {
  EventStart(e, node, path)
}
function EventStart(e, node, path) {
  if (!e.touches) e.preventDefault()
  e.stopPropagation()
  currentNode.value = node
  currentPath.value = path
  // dragPath.value = JSON.parse(JSON.stringify(path))
  oldDate = new Date().getTime()
  canMovePolyline.value = true
  pageX.value = e.pageX ?? e.changedTouches[0].pageX
  pageY.value = e.pageY ?? e.changedTouches[0].pageY
  oldX.value = x.value
  oldY.value = y.value
  oldScale.value = scale.value
  dragPath.value = path

  let diffLeft = 0
  let diffTop = 0
  if (e.touches && (!diffLeft || !diffTop)) {
    let parent = svgWrap.value?.parentElement
    while (parent) {
      diffLeft += parent.offsetLeft ?? 0
      diffTop += parent.offsetTop ?? 0
      parent = (parent.offsetParent ?? parent.parentNode) as HTMLElement
    }
  }

  offsetX.value = (e.offsetX ?? e.changedTouches[0].pageX - diffLeft) // 记录移动起始点offsetX
  offsetY.value = (e.offsetY ?? e.changedTouches[0].pageY - diffTop) // 记录移动起始点offsetY
  // document.getElementById('xxx').innerHTML = offsetX.value + ' ' + e.changedTouches[0].pageX + ' ' + diffLeft
  // document.getElementById('yyy').innerHTML = offsetY.value + ' ' + e.changedTouches[0].pageY + ' ' + diffTop
  // document.getElementById('redpoint').style.left = offsetX.value + 'px'
  // document.getElementById('redpoint').style.top = offsetY.value + 'px'

  document.addEventListener('touchmove', EventMove, false)
  document.addEventListener('touchend', EventEnd, false)
  document.addEventListener('mousemove', EventMove, false)
  document.addEventListener('mouseup', EventEnd, false)
}
// 新增点拖拽移动
function EventMove(e) {
  // 隔离点击事件
  if (new Date().getTime() - oldDate < 300 && (e.pageX ?? e.changedTouches[0].pageX) === pageX.value && (e.pageY ?? e.changedTouches[0].pageY) === pageY.value) {
    return
  }
  if (!e.touches) e.preventDefault()
  e.stopPropagation()
  if (!canMovePolyline.value) return
  if (!state.value.draggingPoint) {
    // 新增点
    let newX = (offsetX.value - x.value) / scale.value
    let newY = (offsetY.value - y.value) / scale.value
    const segmentResult = pointInSegments([newX, newY], dragPath.value!.points)
    if (!segmentResult.index) return
    diffX.value = newX = pointToGrid(newX)
    diffY.value = newY = pointToGrid(newY)
    dragPath.value!.points.splice(segmentResult.index!, 0, [newX, newY])
    dragPoint.value = dragPath.value!.points[segmentResult.index!]
    state.value.draggingPoint = true
  }
  const point = getMovingPoint({
    pageX: (e.pageX ?? e.changedTouches[0].pageX),
    pageY: (e.pageY ?? e.changedTouches[0].pageY),
    oldPageX: pageX.value,
    oldPageY: pageY.value,
    x: x.value,
    y: y.value,
    oldX: oldX.value,
    oldY: oldY.value,
    scale: scale.value,
    oldScale: oldScale.value,
    diffX: diffX.value,
    diffY: diffY.value
  })
  // 计算首/尾点的坐标
  getNearFirstOrLast(point)
  dragPoint.value.splice(0, 2, ...point)
}
// 新增点抬起
function EventEnd(e) {
  if (!e.touches) e.preventDefault()
  e.stopPropagation()
  canMovePolyline.value = false
  state.value.draggingPoint = false
  document.removeEventListener('touchmove', EventMove)
  document.removeEventListener('touchend', EventEnd)
  document.removeEventListener('mousemove', EventMove)
  document.removeEventListener('mouseup', EventEnd)
  if (new Date().getTime() - oldDate <= 300 && pageX.value === (e.pageX ?? e.changedTouches[0].pageX) && pageY.value === (e.pageY ?? e.changedTouches[0].pageY)) {
    onClickPolyline(e)
    return
  }
  // 过滤
  filterPointInSegments(dragPath.value!.points)
  Object.assign(currentPath.value!, JSON.parse(JSON.stringify(dragPath.value)))
  dragPath.value = null
  dragPoint.value.splice(0, 2)
  updateNodeConfigSnapshots()
  // 显示删除按钮及位置设置
  // this.setPositionDelIcon()
}
// 删除按钮位置
// function setPositionDelIcon() {
//   console.log('setPositionDelIcon')
//   const itemX = []
//   const itemY = []
//   for (let i = 0; i < activeLine.value.length; i++) {
//     let item = []

//     item = this.activeLine[i]

//     itemX.push(Number(item[0]))
//     itemY.push(Number(item[1]))
//   }
//   let max = Math.max.apply(null, itemX)
//   let maxY = Math.max.apply(null, itemY)
//   let minY = Math.min.apply(null, itemY)
//   let average = (maxY + minY) / 2
//   this.menuLeftDel = this.x + (max + 15) * this.scale
//   this.menuTopDel = this.y + (average - 40) * this.scale
//   this.delIndex = this.pathindex // 记录鼠标抬起要删除的是第几个nodepath
// }