import { ref, reactive, computed } from 'vue'
import type { INodes, IPaths, IPoint, IState } from '../utils/INodes'

export const svgWrap = ref<SVGSVGElement | null>(null) // svg画布
export const actives = ref<string[]>([]) // 选中结点
export const nodeConfig = ref<INodes[]>([]) // 所有节点数据
export const dragPath = ref<IPaths | null>(null) // 拖拽中的连线
export const dragPoint = ref<number[]>([]) // 拖拽中的连线拐点
export const dragNodes = ref<INodes[]>() // 拖拽中的节点
export const hoverNode = ref<INodes | null>(null) // 鼠标经过的的节点对象
export const hoverPolyine = ref('') // 鼠标经过的polyline
export const nodeConfigSnapshots = ref<INodes[][]>([]) // 节点数据快照
export const nodeConfigSnapshotsIndex = ref(-1) // 当前快照索引
export const x = ref(0) // 偏移 水平
export const y = ref(0) // 偏移 垂直
export const oldX = ref(0) // 拖拽前x
export const oldY = ref(0) // 拖拽前y
export const diffX = ref(0) // 原点坐标x
export const diffY = ref(0) // 原点坐标y
export const scale = ref(1) // 缩放比例
export const oldScale = ref(1) // 原缩放比例
export const pageX = ref(0) // 拖拽前pageX
export const pageY = ref(0) // 拖拽前pageY
export const startX = ref(0) // 圈选拖动 开始坐标x
export const startY = ref(0) // 圈选拖动 开始坐标y
export const xSelection = ref(0) // 圈选拖动 mousemove x
export const ySelection = ref(0) // 圈选拖动 mousemove y
export const offsetX = ref(0) // 拖拽偏移x
export const offsetY = ref(0) // 拖拽偏移y
export const state = ref({
  draggingSVG: false, // 拖拽画布中
  draggingNodes: false, // 拖拽节点中
  draggingPolyline: false, // 拖拽连线点
  draggingPoint: false, // 拖拽点
  draggingSegment: false, // 拖拽线段
  showSelection: false, // 圈选 鼠标移动时，圈选框是否显示
  isHoverPolyline: computed(() => hoverPolyine.value), // 鼠标经过连线
  isHoverNode: false // 连线时，鼠标是否经过节点
})

export const canMoveNodes = ref(false) // 节点可拖动状态
export const dragNode = ref<INodes>() // 单独一个节点对象
export const floating = ref([0, 0])
export const currentNode = ref<INodes | null>(null) // 当前拖拽点所属node
export const currentPath = ref<IPaths | null>(null) // 当前path
export const canMovePolyline = ref(false) // 线可拖动状态
export const segment = ref<string[] | null>(null) // ['123,321', '321,123']包含2个点的线段
export const isStartPoint = ref(false)
export const isEndPoint = ref(false)
export const show = reactive({
  node: false,
  save: false // 是否显示保存
})
export const loading = reactive({
  submit: false
})