export type IPoint = number[]
export interface IPaths {
  id: string
  from: {
    originX: number
    originY: number
    id: string
  }
  to: {
    originX: number
    originY: number
    id: string
  }
  type: number
  points: Array<IPoint>
}
export interface INodePath {
  position: {
    x: number
    y: number
    lastX?: number
    lastY?: number
  }
  from: string[]
  to: string[]
  size: {
    width: number
    height: number
  }
  paths: Array<IPaths>
}
export interface IDefaultMonitor {
  subProcessStartCondition: string, // 子流程触发条件。条件满足触发。不满足跳过 js表达式（不必填）
  subProcessStartUrl: string, // 子流程触发地址
  subParentNodeEndWay: string, // 当前节点结束方式（1直接触发并进入下一步审核任务，2 直接触发并需进行回调后继续进行下一步审核任务） 单选
  customData: string // body参数（不必填） textarea多行
}

export interface INodes {
  'id': string
  'processId'?: number
  'nodeCode': string
  'nodeType': string
  'nodeName': string
  'inputNodeCode': string[]
  'outputNodeCode': string[]
  'userType': string // 1角色 2部门 3协同部门 4指定审核人
  'userTypeParams': string[] // 审批类型参数，此处拓展可自定义参数，由流程推给业务，业务返回审批人员
  'userTypeSelectIds': string[] // 审批选择ids，逗号分隔 1标签/角色(id)，2部门(id), 3协同部门(id), 4指定审核人(id;user_name)，逗号分隔
  'signType': string // 1会签 2或签
  'conditionParams': string // 条件参数，js表达式方式 ex:$price$ > 21
  'callbackFlag': string // 节点是否存在监听（也就是回调）0否1是，默认0
  'isSubProcess': string // 是否关联子流程（0否，1是）默认0
  'isParallel': string // 是否在并行审批节点中（0否，1是）默认0  非用户操作，必传（需要前端判断当前节点是否属于并行网关子节点）
  'isPostParent'?: string // 是否直属上级
  'freeSelectInputNodeCode'?: string // 上节点指定审批人
  'parentFinalPostId'?: string // 审核节点 - 上级岗位id
  'approveTimeLimitType': string // 审批时限类型（1小时，2天）默认1
  'approveTimeLimit': number // 审批时限值
  'applicationId': string // 对应业务系统ID(应用ID)（不必填）
  'applicationTodoUrl': string // 业务系统的待办地址（不必填）
  'nodePath': INodePath
  'authConfig'?: any
  'nodeButtonConfig': any[] // 按钮
  'nodeMonitorConfig': any[] // 节点监听
  'nodeSubprocessesConfig': IDefaultMonitor[]
  isCopy?: boolean
}

export interface IState {
  draggingSVG: boolean // 拖拽画布中
  draggingNodes: boolean // 拖拽节点中
  draggingPolyline: boolean // 拖拽连线点
  draggingPoint: boolean // 拖拽点
  draggingSegment: boolean // 拖拽线段
  showSelection: boolean // 圈选 鼠标移动时，圈选框是否显示
  isHoverPolyline: boolean // 鼠标经过连线
  isHoverNode: boolean // 连线时，鼠标是否经过节点
}

export interface IShow {
  node: boolean
}